/*
 * Decompiled with CFR 0.152.
 */
package io.github.ationmc.installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MainGUI
extends JFrame {
    public MainGUI() throws HeadlessException {
        super("Ation Installer");
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(this.getOwner());
        this.setSize(500, 200);
        this.setLayout(new FlowLayout());
        JPanel gameVersionPanel = new JPanel();
        gameVersionPanel.add(new JLabel("Game version:"));
        JComboBox gameVersionCombo = new JComboBox();
        new Thread(() -> {
            JsonArray versions = new Gson().fromJson(this.readString("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json"), JsonObject.class).get("versions").getAsJsonArray();
            for (JsonElement jsonElement : versions) {
                gameVersionCombo.addItem(jsonElement.getAsJsonObject().get("id").getAsString());
            }
        }).start();
        gameVersionPanel.add(gameVersionCombo);
        this.add((Component)gameVersionPanel, "North");
        JPanel loaderVersionPanel = new JPanel();
        loaderVersionPanel.add(new JLabel("Loader version:"));
        JComboBox loaderVersionCombo = new JComboBox();
        new Thread(() -> {
            String xml = this.readString("https://ationmc.github.io/maven/io/github/ationmc/AtionLoader/maven-metadata.xml");
            String allLoaderVersion = xml.substring(xml.indexOf("<versions>") + "<versions>".length(), xml.lastIndexOf("</versions>")).replaceAll("\\s", "");
            String[] split = allLoaderVersion.split("(<version>|</version>)");
            for (int i = split.length - 1; i >= 0; --i) {
                if (split[i].equals("")) continue;
                loaderVersionCombo.addItem(split[i]);
            }
        }).start();
        loaderVersionPanel.add(loaderVersionCombo);
        this.add(loaderVersionPanel);
        JPanel path = new JPanel();
        path.add(new JLabel("Path"));
        path.add(new JTextField(this.getMinecraftDir().getAbsolutePath()));
        this.add((Component)path, "Center");
        JButton install = new JButton("Install");
        install.addActionListener(e -> {
            Object gameVersion = gameVersionCombo.getSelectedItem();
            Object loaderVersion = loaderVersionCombo.getSelectedItem();
            if (gameVersion == null || loaderVersion == null) {
                JOptionPane.showMessageDialog(null, "please wait");
            } else {
                try {
                    String name = String.format("Ation-%s-%s", gameVersion, loaderVersion);
                    File dir = new File(this.getMinecraftDir(), "versions/" + name);
                    if (!dir.exists()) {
                        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                    }
                    String string = this.getString(this.getClass().getResourceAsStream("/config.json"));
                    string = string.replace("${gameVersion}", gameVersion.toString());
                    string = string.replace("${loaderVersion}", loaderVersion.toString());
                    string = string.replace("${formattedTime}", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date()));
                    Files.write(new File(dir, name + ".json").toPath(), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    JOptionPane.showMessageDialog(null, "Success!");
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, exception);
                }
            }
        });
        this.add(install);
    }

    private File getMinecraftDir() {
        File minecraftFolder = this.getOsName().contains("win") ? new File(System.getenv("APPDATA"), File.separator + ".minecraft") : (this.getOsName().contains("mac") ? new File(System.getProperty("user.home"), File.separator + "Library" + File.separator + "Application Support" + File.separator + "minecraft") : new File(System.getProperty("user.home"), File.separator + ".minecraft"));
        return minecraftFolder;
    }

    private String getOsName() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT);
    }

    private String readString(String link) {
        try {
            URL url = new URL(link);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection connection = null;
            if (urlConnection instanceof HttpURLConnection) {
                connection = (HttpURLConnection)urlConnection;
            }
            if (connection == null) {
                throw new NullPointerException(String.format("Link: '%s' fail", link));
            }
            return this.getString(connection.getInputStream());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
            return null;
        }
    }

    private String getString(InputStream inputStream) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line).append("\n");
        }
        return stringBuilder.toString();
    }
}

